/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;

public class DateTime extends Composite {

public DateTime (Composite parent, int style) {
	super (parent, checkStyle (style));
}

public void addSelectionListener (SelectionListener listener) {
}

static int checkStyle (int style) {
	/*
	* Even though it is legal to create this widget
	* with scroll bars, they serve no useful purpose
	* because they do not automatically scroll the
	* widget's client area.  The fix is to clear
	* the SWT style.
	*/
	style &= ~(SWT.H_SCROLL | SWT.V_SCROLL);
	style = checkBits (style, SWT.DATE, SWT.TIME, SWT.CALENDAR, 0, 0, 0);
	return checkBits (style, SWT.MEDIUM, SWT.SHORT, SWT.LONG, 0, 0, 0);
}

protected void checkSubclass () {
}

public Point computeSize (int wHint, int hHint, boolean changed) {
//TODO make use of changed
	Rectangle rectangle = getNativeBounds();
	int width = rectangle.width;
	int height = rectangle.height;
	if (wHint != SWT.DEFAULT) width = wHint;
	if (hHint != SWT.DEFAULT) height = hHint;
	return new Point (width, height);
}

public int getDay () {
	return 0;
}

public int getHours () {
	return 0;
}

public int getMinutes () {
	return 0;
}

public int getMonth () {
	return 0;
}

public int getSeconds () {
	return 0;
}

public int getYear () {
	return 0;
}

public void removeSelectionListener (SelectionListener listener) {
}

public void setDay (int day) {
}

public void setHours (int hours) {
}

public void setMinutes (int minutes) {
}

public void setMonth (int month) {
}

public void setSeconds (int seconds) {
}

public void setYear (int year) {
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if((style & (@org.eclipse.swt.SWT::CALENDAR)) != 0) {
		if(!$wnd.dojo._hasResource["org.eclipse.swt.Calendar"]){
			$wnd.dojo._hasResource["org.eclipse.swt.Calendar"] = true;
			$wnd.dojo.provide("org.eclipse.swt.Calendar");
			
			$wnd.dojo.require("dijit._Calendar");
		
			$wnd.dojo.declare("org.eclipse.swt.Calendar", $wnd.dijit._Calendar, {
				postCreate: function(){
 					this.inherited("postCreate",arguments);
					if (this.border) {$wnd.swt.setCssStyle(this.domNode, {border: this.border});}
				},
				resize: function(){},
				setAlignment: function(alignment){
					this.domNode.align = alignment;
				}
			});
		}
	}
	if(((style & (@org.eclipse.swt.SWT::DATE)) != 0) || style==@org.eclipse.swt.SWT::NONE) {
		if(!$wnd.dojo._hasResource["org.eclipse.swt.Date"]){
			$wnd.dojo._hasResource["org.eclipse.swt.Date"] = true;
			$wnd.dojo.provide("org.eclipse.swt.Date");
			
			$wnd.dojo.require("dijit.form.DateTextBox");
		
			$wnd.dojo.declare("org.eclipse.swt.Date", $wnd.dijit.form.DateTextBox, {
				formatLength: "medium",
				getNativeBounds: function(){
					var dnLoc = $wnd.swt.getNativeLocation(this.domNode);
					var dnExt = $wnd.dojo._getPadBorderExtents(this.domNode);
					var tbSize = $wnd.swt.getNativeSize(this.textbox);
					return {l:dnLoc.l, t:dnLoc.t, w: dnExt.w+tbSize.w, h:dnExt.h+tbSize.h};
				},
				postCreate: function(){
					this.constraints.formatLength = this.formatLength;
					this.inherited("postCreate",arguments); 
					this.setValue(new Date());
					$wnd.swt.setCssStyle(this.domNode,{overflow: "hidden"});
					if (this.border) {$wnd.swt.setCssStyle(this.domNode, {border: this.border});}
					$wnd.swt.setCssStyle(
						$wnd.dojo.query(".dijitValidationIcon",this.domNode)[0],
						{width: 0, padding: 0}
					);
				},
				resize: function(){},
				setAlignment: function(alignment){
					this.domNode.align = alignment;
				}
			});
		}
	}
	if((style & (@org.eclipse.swt.SWT::TIME)) != 0) {
		if(!$wnd.dojo._hasResource["org.eclipse.swt.Time"]){
			$wnd.dojo._hasResource["org.eclipse.swt.Time"] = true;
			$wnd.dojo.provide("org.eclipse.swt.Time");
			
			$wnd.dojo.require("dijit.form.TimeTextBox");
		
			$wnd.dojo.declare("org.eclipse.swt.Time", $wnd.dijit.form.TimeTextBox, {
				formatLength: "medium",
				getNativeBounds: function(){
					var dnLoc = $wnd.swt.getNativeLocation(this.domNode);
					var dnExt = $wnd.dojo._getPadBorderExtents(this.domNode);
					var tbSize = $wnd.swt.getNativeSize(this.textbox);
					return {l:dnLoc.l, t:dnLoc.t, w: dnExt.w+tbSize.w, h:dnExt.h+tbSize.h};
				},
				postCreate: function(){
					this.constraints.formatLength = this.formatLength;
					this.inherited("postCreate",arguments); 
					this.setValue(new Date());
					$wnd.swt.setCssStyle(this.domNode,{overflow: "hidden"});
					if (this.border) {$wnd.swt.setCssStyle(this.domNode, {border: this.border});}
					$wnd.swt.setCssStyle(
						$wnd.dojo.query(".dijitValidationIcon",this.domNode)[0],
						{width: 0, padding: "0px"}
					);
				},
				resize: function(){},
				setAlignment: function(alignment){
					this.domNode.align = alignment;
				}
			});
		}
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var params = {};
	if((style & (@org.eclipse.swt.SWT::BORDER)) != 0){
		params.border = "1px solid black";
	}
	if((style & (@org.eclipse.swt.SWT::SHORT)) != 0) {
		params.formatLength = "short";
	} else if((style & (@org.eclipse.swt.SWT::MEDIUM)) != 0) {
		params.formatLength = "medium";
	} else if((style & (@org.eclipse.swt.SWT::LONG)) != 0) {
		params.formatLength = "long";
	}
	if((style & (@org.eclipse.swt.SWT::CALENDAR)) != 0) {
		var self = new $wnd.org.eclipse.swt.Calendar(params);        	
	} else if((style & (@org.eclipse.swt.SWT::DATE)) != 0) {
		var self = new $wnd.org.eclipse.swt.Date(params);
	} else if((style & (@org.eclipse.swt.SWT::TIME)) != 0) {
		var self = new $wnd.org.eclipse.swt.Time(params);        	
	} else if(style==@org.eclipse.swt.SWT::NONE) {
		var self = new $wnd.org.eclipse.swt.Date(params);
	}
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//Have to throw real exeption for Java side also	
		$wnd.console.log(e);
	}
}-*/;

}